#include "stdafx.h"
#include "common.h"
#include "tree.h"
#include "error.h"
#include "weed.h"
#include "asmutils.h"

//****************************************************************************************************************
/*zaciname s plenim u korenu stromu*/
//****************************************************************************************************************
void CWeeding::Process(SCRIPT*	theScript)
{
	if (theScript->toplevels != NULL)			//pokud mame nejake toplevely
		processTOPLEVEL(theScript->toplevels);		//preplejem vsechny toplevely
}

//****************************************************************************************************************
//prochazeni toplevelu
//****************************************************************************************************************
void CWeeding::processTOPLEVEL(TOPLEVEL* toplevel)
{
	processFUNCTION(toplevel->function);		//pleni funkce

	if (toplevel->next != NULL)				//pleni dalsiho toplevelu
		processTOPLEVEL(toplevel->next);
}
//****************************************************************************************************************
//pruchod fci
//****************************************************************************************************************
void CWeeding::processFUNCTION(FUNCTION* function)
{
	switch (function->kind)
	{
	case localT:			//lokalni fce, je definovana ve skriptu
		if (function->declaration != NULL)				//pokud ma funkce nejake parametry
			processDECLARATION(function->declaration);		//musime je taky zkontrolovat

		function->returns_value = false;
		if (function->statements != NULL)				//pokud ma funkce nejake telo, 
		{
			processSTATEMENT(function->statements);		//zkontrolujeme kazdy prikaz v jejim tele a pak zkontrolujeme zda obsahuje return
			function->returns_value = processSTATEMENTCheckIfReturnsValue(function->statements);
			processSTATEMENTForUnreachableCode(function->statements);
		}
	

		//zmen jmeno funkce tak aby bylo slozeno ze jmena funkce a podpisu, to nam dovoli
		//pouzivat pretizene funkce
		function->signature = stringConcat(function->name,makeSignature(function),NULL);
		break;
	case externT:
		//u externi fce zkusime jestli jsou nazvy platne a jestli muzem ziskat jeji adresu
		FARPROC		funcadress = NULL;
		HMODULE		hDll = NULL;
		
		//nejdriv ziskat handle knihovny, tato fce pocita s tim ze je knihovna nactena v pameti
		hDll = GetModuleHandle(function->library);
		if (!hDll)
		{
			//knihovna neni v pameti nactena, takze ji nacteme a ziskame na ni drzadlo pomoci fce LoadLibrary
			hDll = LoadLibrary(function->library);
			if (!hDll)	//pokud se to nepovede, nahlasime warning. Knihovna jen nemusi byt v systemovem adresari nebo v adresari s
				//kompilerem, ale az bude program spusten pravdepodobne uz bude pritomna
				theLog.ReportWarning(function->line_number,"Warning: Cannot load library %s to check if it contains function %s.\n",function->library,function->name);
		}

		//pokud mame handle knihovny
		if (hDll)
		{
			//pokusime se ziskat adresu externi funkce
			funcadress = GetProcAddress(hDll,function->name);
			if (!funcadress)	//opet vypis pokud se to nepovede
				theLog.ReportWarning(function->line_number,"Warning: Failed to retrieve adress of function %s. The name of function is invalid or it is located at other library!\n",function->name);

			FreeLibrary(hDll);
		}

		//nastav u funkce jestli vraci hodnotu
		function->returns_value = (function->type->kind == voidT) ? false : true;
	}
}

//****************************************************************************************************************
/*Fce pro kontrolu zda funkce obsahuje prikaz return a zda ho obsahuje vsude kde ma byt, aby
nevznikaly chyby kdy nejsou kdy nekontrolujeme vsechny moyne cesty kudy vratit hodnotu */
//****************************************************************************************************************
bool CWeeding::processSTATEMENTCheckIfReturnsValue(STATEMENT* statement)
{
	switch (statement->kind)
	{
	case returnT:		//pokud narazime na return, vratime true ze jsme nasli return
		if (statement->val.returnS.expression)
			return true;
		else
			//function->returns_value = false;
			return false;
	case forT:
		return processSTATEMENTCheckIfReturnsValue(statement->val.forS.body);
	case whileT:
		return processSTATEMENTCheckIfReturnsValue(statement->val.whileS.body);
	case ifT:
		return processSTATEMENTCheckIfReturnsValue(statement->val.ifS.body);
	case ifelseT:
		//hledej return v if casti tela prikazu if-else i v casti else
		if (processSTATEMENTCheckIfReturnsValue(statement->val.ifelseS.ifbody) ||
			processSTATEMENTCheckIfReturnsValue(statement->val.ifelseS.elsebody))
			return true;
		return false;
	case sequenceT:
		if (processSTATEMENTCheckIfReturnsValue(statement->val.sequenceS.firts) ||
			 processSTATEMENTCheckIfReturnsValue(statement->val.sequenceS.second))
			 return true;
		else
			return false;
	case scopeT:
		/*scope taky musime zkontrolovat*/
		return processSTATEMENTCheckIfReturnsValue(statement->val.scopeS.statement);
	default:
		return false;
	}
}

bool CWeeding::processSTATEMENTForUnreachableCode(STATEMENT* statement)
{
	switch (statement->kind)
	{
	case returnT:		//pokud narazime na return, vratime true ze jsme nasli return
		return true;
	case ifelseT:
		//hledej return v if casti tela prikazu if-else i v casti else
		if (processSTATEMENTForUnreachableCode(statement->val.ifelseS.ifbody) ||
			processSTATEMENTForUnreachableCode(statement->val.ifelseS.elsebody))
			return true;
		return false;
	case sequenceT:
		if (processSTATEMENTForUnreachableCode(statement->val.sequenceS.firts))
		{
			theLog.ReportWarning(statement->line_number,"Unreachable Code");
			return true;
		}
		else
			return processSTATEMENTForUnreachableCode(statement->val.sequenceS.second);
	case scopeT:
		/*scope taky musime zkontrolovat*/
		return processSTATEMENTForUnreachableCode(statement->val.scopeS.statement);
	default:
		return false;
	}
}

//****************************************************************************************************************
//pruchod deklaracemi
//****************************************************************************************************************
void CWeeding::processDECLARATION(DECLARATION* declaration)
{
	DECLARATION* tmp;				//docasna deklarace
	switch (declaration->kind)
	{
	case formalT:
		break;
	case variableT:
		/*prevedeni seznamu identifikatoru na seznam deklaraci
		prevedeni deklarace jako int a, b = 0; na int a=0; int b=0;
		*/
		if (declaration->val.variableD.identifiers->next != NULL) //pokud deklarace promenne obsahuje vice identifikatoru
		{
			tmp = declaration->next;							  //ulozime si docasne ukazatel na nasledujici deklaraci
			//jako dalsi deklaraci vytvorime deklaraci promenne se stejnym identifikatorem, stejneho typu,
			//identifikator bude dalsi v seznamu a inicilizace taky stejna
			//clenska promenna identifiers muze trochu mast. predstavuje ukazatel na prvni identifikator
			//a ten pak pomoci promenne next ukazuje na dalsi identifikatory. Takze my v jednom kroku vlastne 
			//zmensime seznam identifikatoru o jedna, z jednoho identifikatoru udelame deklaraci samostatne promenne
			//a tuto deklaraci vlozime mezi declaration a declaration->next, respektive tu na kterou ukazuje tmp
			//dalsi rekurye bude pokracovat na declaration->next, kde bude ale vlozena tato nova deklarace a ta bude
			//obsahovat v promenne identifiers zbyle identifikatory, ktere postupne po jednom prevedeme vsechny na
			//deklaraci promenne
			declaration->next = makeDECLARATIONvariable(declaration->val.variableD.identifiers->next,
														declaration->val.variableD.initialization);
			//vynulujeme ukazatel na dalsi identifikatory v seznamu
			declaration->val.variableD.identifiers->next = NULL;
			//ukazatel na dalsi deklaraci v nove vytvorene deklaraci promenne nastavime na puvodni
			//deklaraci kterou mame ulozenou v docasne promenne
			declaration->next->next = tmp;
		}
		
		//este zkontrolujeme zda je promenna inicializovana, pokud ne, incializujeme ji na nula
		if (!declaration->val.variableD.initialization)
		{
			//informuj o tom ze inicializujes na nulu
			theLog.TraceF("Variable '%s' is not initialized. Initializing it to zero.<br>",declaration->val.variableD.identifiers->name);
                
			declaration->val.variableD.initialization = makeEXPRESSIONintconst(0);
		}
		
		processEXPRESSION(declaration->val.variableD.initialization);
		break;
	case simplevarT:
		//pokud promenna nnei inicilizovana, automaticky ji inicializujeme na nulu, jelikoz to je jedna
		//z vlastnosti naseho jazyka, totiz automaticka inicializace
		if (!declaration->val.simplevarD.initialization)
		{
				theLog.TraceF("Variable '%s' is not initialized. Initializing it to zero.<br>",declaration->val.simplevarD.name);		

				declaration->val.simplevarD.initialization = makeEXPRESSIONintconst(0);
		}
		
		//ted uz je jasne ze nam sem nepronikne promenna bez inicializace
		processEXPRESSION(declaration->val.simplevarD.initialization);

		break;
	}

	if (declaration->next != NULL)
		processDECLARATION(declaration->next);
}
//****************************************************************************************************************
//pruchod inicializaci cyklu for
//****************************************************************************************************************
void CWeeding::processFORINIT(FORINIT* forinit)
{
	switch (forinit->kind)
	{
	case declarationforinitT:
		processDECLARATION(forinit->val.declarationF);
		break;
	case expressionforinitT:
		processEXPRESSION(forinit->val.expressionF);
		break;
	}
}
//****************************************************************************************************************
//pruchod prikazy
//****************************************************************************************************************
void CWeeding::processSTATEMENT(STATEMENT* statement)
{
	switch(statement->kind)
	{
	case skipT:
		break;
	case returnT:
		break;
	case scopeT:
		/*u scope odstranime zdvojene {{}} ktery vznika treba u for, kvuli lang.y kde je definovano
		ze telo kazdeho for musi byt uzavreno v bloku {}, stejne jako u if ktery ma ve vetvi jen jeden prikaz
        a kdy {} jsou vkladany automatiky parserem, takze proste pokud u scope zjistime, ze dalsi prikaz
		je taky scope, tak jeden scope proste preskocime a nasmerujeme ukazatel u prvniho prikazu scope na
		prikaz ktery nasleduje po druhem scope prikazu
		*/
		if (statement->val.scopeS.statement->kind == scopeT)
			statement->val.scopeS.statement = statement->val.scopeS.statement->val.scopeS.statement;
		processSTATEMENT(statement->val.scopeS.statement);
		break;
	case declstmT:
		processDECLARATION(statement->val.declaration);
		break;
	case expT:
		processEXPRESSION(statement->val.expression);
		break;
	case ifT:
		processEXPRESSION(statement->val.ifS.condition);
		/*zachyt podminky kde je jen cislo 0 nebo 0.0 nebo "0", tj. podminky typu if (0). Tyto podminky
		nebudou nikdy provedeny. Pokud je najdem, nahlasime varovani*/
		if (statement->val.ifS.condition->kind == intconstT)
		{
			if (statement->val.ifS.condition->val.intconstE == 0)
				theLog.ReportWarning(statement->line_number,"If body never executed! Condition is always false!");
		}
		if (statement->val.ifS.condition->kind == doubleconstT)
		{
			if (statement->val.ifS.condition->val.doubleconstE == 0.0f)
				theLog.ReportWarning(statement->line_number,"If body never executed! Condition is always false!");
		}
		if (statement->val.ifS.condition->kind == stringconstT)
		{
			if (atof(statement->val.ifS.condition->val.stringconstE) == 0.0f)
				theLog.ReportWarning(statement->line_number,"If body never executed! Condition is always false!");
		}
		processSTATEMENT(statement->val.ifS.body);
		break;
	case ifelseT:
		processEXPRESSION(statement->val.ifelseS.condition);
		processSTATEMENT(statement->val.ifelseS.ifbody);
		processSTATEMENT(statement->val.ifelseS.elsebody);
		break;
	case whileT:
		processEXPRESSION(statement->val.whileS.condition);
		processSTATEMENT(statement->val.whileS.body);
		break;
	case forT:
		processFORINIT(statement->val.forS.inits);
		processEXPRESSION(statement->val.forS.condition);
		processEXPRESSION(statement->val.forS.updates);
		processSTATEMENT(statement->val.forS.body);
		break;
	case sequenceT:
		processSTATEMENT(statement->val.sequenceS.firts);
		processSTATEMENT(statement->val.sequenceS.second);
		break;
	}
}
//****************************************************************************************************************
//Pruchod vyrazem
//****************************************************************************************************************
void CWeeding::processEXPRESSION(EXPRESSION* expression)
{
	if (expression == NULL)
		return;

	switch (expression->kind)
	{
	case intconstT:
		break;
	case stringconstT:
		break;
	case uminusT:
		processEXPRESSION(expression->val.uminusE);
		break;
	case notT:
		processEXPRESSION(expression->val.notE.expression);
		break;
	case lvalueT:
		break;
	case assignmentT:
		processEXPRESSION(expression->val.assignmentE.right);
		break;
	case equalsT:
		processEXPRESSION(expression->val.equalsE.left);
		processEXPRESSION(expression->val.equalsE.right);
		break;
	case nequalsT:
		processEXPRESSION(expression->val.nequalsE.left);
		processEXPRESSION(expression->val.nequalsE.right);
	case lessT:
		processEXPRESSION(expression->val.lessE.left);
		processEXPRESSION(expression->val.lessE.right);
		break;
	case lequalsT:
		processEXPRESSION(expression->val.lequalsE.left);
		processEXPRESSION(expression->val.lequalsE.right);
		break;
	case gequalsT:
		processEXPRESSION(expression->val.gequalsE.left);
		processEXPRESSION(expression->val.gequalsE.right);
		break;
	case plusT:
		processEXPRESSION(expression->val.plusE.left);
		processEXPRESSION(expression->val.plusE.right);
		break;
	case minusT:
		processEXPRESSION(expression->val.minusE.left);
		processEXPRESSION(expression->val.minusE.right);
		break;
	case mulT:
		processEXPRESSION(expression->val.mulE.left);
		processEXPRESSION(expression->val.mulE.right);
		break;
	case divT:
		processEXPRESSION(expression->val.divE.left);
		/*zachyceni pokusu o deleni nulou
		staci jen zjistit zda vyraz na prave strane je ciselna konstanta  a pokud ano
		jestli je to nula. Pokud je to nula, jde jasne o deleni nulou. Pokud vyraz na prave strane neni
		cislo ale dalsi vyraz, pokracujeme v rekurzi dale
		*/
		switch (expression->val.divE.right->kind)
		{
		case intconstT:
			if (expression->val.divE.right->val.intconstE == 0)
				theLog.ReportError(expression->val.divE.right->line_number,"Division by zero!");
			break;
		case doubleconstT:
			if (expression->val.divE.right->val.doubleconstE == 0.0f)
				theLog.ReportError(expression->val.divE.right->line_number,"Division by zero!");
			break;
		case stringconstT:
			if (atof(expression->val.divE.right->val.stringconstE) == 0.0)
				theLog.ReportError(expression->val.divE.right->line_number,"Division by zero!");
			break;
		default:
			processEXPRESSION(expression->val.divE.right);
		}	
		break;
	case modT:
		processEXPRESSION(expression->val.modE.left);
		processEXPRESSION(expression->val.modE.right);
		break;
	case andT:
		processEXPRESSION(expression->val.andE.left);
		processEXPRESSION(expression->val.andE.right);
		break;
	case orT:
		processEXPRESSION(expression->val.orE.left);
		processEXPRESSION(expression->val.orE.right);
		break;
	case bitorT:
		processEXPRESSION(expression->val.bitorE.left);
		processEXPRESSION(expression->val.bitorE.right);
		break;
	case bitandT:
		processEXPRESSION(expression->val.bitandE.left);
		processEXPRESSION(expression->val.bitandE.right);
		break;
	case plusassignT:
		processEXPRESSION(expression->val.plusassignE.right);
		break;
	case minusassignT:
		processEXPRESSION(expression->val.minusassignE.right);
		break;
	case mulassignT:
		processEXPRESSION(expression->val.mulassignE.right);
		break;
	case divassignT:
		//zase hlidani pokusu o deleni nulou
		switch (expression->val.divassignE.right->kind)
		{
		case intconstT:
			if (expression->val.divassignE.right->val.intconstE == 0)
				theLog.ReportError(expression->val.divassignE.right->line_number,"Division by zero!");
			break;
		case doubleconstT:
			if (expression->val.divassignE.right->val.doubleconstE == 0.0f)
				theLog.ReportError(expression->val.divassignE.right->line_number,"Division by zero!");
			break;
		case stringconstT:
			if (atof(expression->val.divassignE.right->val.stringconstE) == 0.0)
				theLog.ReportError(expression->val.divassignE.right->line_number,"Division by zero!");
			break;
		default:
			processEXPRESSION(expression->val.divassignE.right);
		}	
		break;
	case modassignT:
		processEXPRESSION(expression->val.modassignE.right);
		break;
	case orassignT:
		processEXPRESSION(expression->val.orassignE.right);
		break;
	case andassignT:
		processEXPRESSION(expression->val.andassignE.right);
		break;
	case shlassignT:
		processEXPRESSION(expression->val.shlassignE.right);
		break;
	case shrassignT:
		processEXPRESSION(expression->val.shrassignE.right);
		break;
	case shlT:
		processEXPRESSION(expression->val.shlE.left);
		processEXPRESSION(expression->val.shlE.right);
		break;
	case shrT:
		processEXPRESSION(expression->val.shrE.left);
		processEXPRESSION(expression->val.shrE.right);
		break;
	case prefincT:
	case postincT:
	case prefdecT:
	case postdecT:
		break;
	case callT:
		if (expression->val.callE.arguments != NULL)
			processEXPRESSION(expression->val.callE.arguments);
		break;
	}

	if (expression->next != NULL)
		processEXPRESSION(expression->next);
}